<?php
function changePass($id)
{
   $sock = Login();
   checkActionAccess($sock, "write");
   $UserIndex = 1;

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $pass = $object["pass"];
   $id = $object["id"];

   $arr = ParamGet($sock, "security");
   $users = $arr->security->user;

   foreach ($users as $user) {
      if ($user->id == $id) {
         $UserIndex = $user->index;
         $param = "security.user.[" . $UserIndex . "].password";
         ParamSetString($sock, $param, ConvertUTF2Native($pass));
      }
   }
   socket_close($sock);
}
function getChannelName($lang)
{
   switch ($lang) {
      case "ru":
         return "Канал";
      case "en":
         return "Channel";
   }
}
function changeIpcams()
{
   $sock = Login();
   checkActionAccess($sock, "write");
   $ipcams = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($ipcams);
   $ipcams = $ipcams["ipcams"];

   $arr2 = ParamGet($sock, "video");
   if (isset($ipcams)) {
      if (isset($arr2->video->ipcams)) {
         if ($arr2->video->ipcams != $ipcams) {
            ParamSetInt($sock, "video.ipcams", $ipcams);
            if (isset($arr2->video->input)) {
               $cameras = $arr2->video->input;
               $cameras = sort_nested_arrays($cameras, ["index" => "desc"]);
               for ($i = 0; $i < $ipcams; $i++) {
                  if (!isset($cameras[$i])) {
                     ParamSetInt($sock, "video.input.[" . $i . "].index", $i);
                     ParamSetInt($sock, "video.input.[" . $i . "].enabled", 0);
                     $index = $i + 1;
                     ParamSetString($sock, "video.input.[" . $i . "].title1251", "Канал " . $index);
                     ParamSetString($sock, "video.input.[" . $index . "].titleUtf", "Канал " . $index, false);
                  }
               }
            }
         }
      } else {
         $ipcams = $ipcams;
         ParamSetInt($sock, "video.ipcams", $ipcams);
         for ($i = 0; $i < $ipcams; $i++) {
            ParamSetInt($sock, "video.input.[" . $i . "].index", $i);
            ParamSetInt($sock, "video.input.[" . $i . "].enabled", 0);
            $index = $i + 1;
            ParamSetString($sock, "video.input.[" . $i . "].title1251", "Канал " . $index);
            ParamSetString($sock, "video.input.[" . $index . "].titleUtf", "Канал " . $index, false);
         }
      }
   }
   // ************************* Добавить в следующую версию, как на пк конф *****************************
   /*     if (isset($ipcams)) {
        if (isset($arr2->video->ipcams)) {
            if ($arr2->video->ipcams != $ipcams) {
                ParamSetInt($sock, "video.ipcams", $ipcams);
            }
        } else {
            ParamSetInt($sock, "video.ipcams", $ipcams);
        }
    } */
}
function changeBasic()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $server = ParamGet($sock, "server");
   $server = $server->server;

   if (isset($object["timeoffset"])) {
      $timeoffset = $object["timeoffset"];
      if (isset($server->timeoffset)) {
         if ($server->timeoffset != $object["timeoffset"]) {
            ParamSetInt($sock, "server.timeoffset", $timeoffset);
         }
      } else {
         ParamSetInt($sock, "server.timeoffset", $timeoffset);
      }
   }

   if (isset($object["name"]) && $object["name"] != "") {
      $name = $object["name"];
      ParamSetString($sock, "server.title1251", $name);
   } else {
      ParamUnset($sock, "server.title1251");
   }

   $isServerReboot = false;

   if (isset($object["httpdigestport"])) {
      $httpdigestport = $object["httpdigestport"];
      ParamSetInt($sock, "server.httpdigestport", $httpdigestport);
      $isServerReboot = true;
   }
   if (isset($object["rtspport"])) {
      $rtspport = $object["rtspport"];
      ParamSetInt($sock, "server.rtspport", $rtspport);
      if (!$isServerReboot) {
         $isServerReboot = true;
      }
   }

   changeNTP($sock, $server, $object);
   changeSNMP($sock, $server, $object);
   changeUpLink($sock, $server, $object);
   changeNat($sock, $server, $object);

   if ($isServerReboot) {
      ParamSetInt($sock, "server.eth0", 0);
   }

   socket_close($sock);
   return true;
}

function changeNTP($sock, $server, $object)
{
   if (!isset($object["ntp"]["enabled"])) {
      return;
   }

   $isEnabled = $object["ntp"]["enabled"];

   if ($isEnabled == false || $isEnabled == 0) {
      if (isset($server->ntp->ntpserverip)) {
         ParamUnset($sock, "server.ntp.ntpserverip");
      }
      if (isset($server->ntp->ntptzoffset)) {
         ParamUnset($sock, "server.ntp.ntptzoffset");
      }
      return;
   }

   if ($isEnabled != true && $isEnabled != 1) {
      return;
   }

   if (isset($object["ntp"]["ntpserverip"])) {
      $ntpServerIp = $object["ntp"]["ntpserverip"];

      if ($ntpServerIp == "" || $ntpServerIp == "0.0.0.0") {
         if (isset($server->ntp->ntpserverip)) {
            ParamUnset($sock, "server.ntp.ntpserverip");
         }
      } else {
         if (isset($server->ntp->ntpserverip)) {
            if ($server->ntp->ntpserverip != $ntpServerIp) {
               ParamSetString($sock, "server.ntp.ntpserverip", $ntpServerIp);
            }
         } else {
            ParamSetString($sock, "server.ntp.ntpserverip", $ntpServerIp);
         }
      }
   } else {
      ParamUnset($sock, "server.ntp.ntpserverip");
   }

   if (isset($object["ntp"]["ntptzoffset"])) {
      $UTC_NTP = $object["ntp"]["ntptzoffset"];
      if (!isset($server->ntp->ntptzoffset)) {
         ParamSetInt($sock, "server.ntp.ntptzoffset", $UTC_NTP * 3600);
      } elseif ($server->ntp->ntptzoffset != $UTC_NTP) {
         ParamSetInt($sock, "server.ntp.ntptzoffset", $UTC_NTP * 3600);
      }
   } else {
      if (isset($server->ntp->ntptzoffset)) {
         ParamUnset($sock, "server.ntp.ntptzoffset");
      }
   }
}
function changeNat($sock, $server, $object)
{
   if (!isset($object["nat"])) {
      return;
   }

   if (isset($object["nat"]["enable"])) {
      $enable = intval($object["nat"]["enable"]);
      if (!isset($server->nat->enable)) {
         ParamSetInt($sock, "server.nat.enable", $enable);
      } elseif ($server->nat->enable != $enable) {
         ParamSetInt($sock, "server.nat.enable", $enable);
      }
   }

   if (isset($object["nat"]["address"])) {
      $address = $object["nat"]["address"];
      if (!isset($server->nat->address)) {
         ParamSetString($sock, "server.nat.address", $address);
      } elseif ($server->nat->address != $enable) {
         ParamSetString($sock, "server.nat.address", $address);
      }
   }

   if (isset($object["nat"]["rtsp_port"])) {
      $rtsp_port = intval($object["nat"]["rtsp_port"]);
      if (!isset($server->nat->rtsp_port)) {
         ParamSetInt($sock, "server.nat.rtsp_port", $rtsp_port);
      } elseif ($server->nat->enable != $rtsp_port) {
         ParamSetInt($sock, "server.nat.rtsp_port", $rtsp_port);
      }
   }

   if (isset($object["nat"]["http_port"])) {
      $http_port = intval($object["nat"]["http_port"]);
      if (!isset($server->nat->http_port)) {
         ParamSetInt($sock, "server.nat.http_port", $http_port);
      } elseif ($server->nat->enable != $http_port) {
         ParamSetInt($sock, "server.nat.http_port", $http_port);
      }
   }
}
function changeSNMP($sock, $server, $object)
{
   if (!isset($object["snmp"]["enabled"])) {
      return;
   }

   $isEnabled = 0;
   $trapip = "0.0.0.0";
   $port = 0;

   if ($object["snmp"]["enabled"] == true || $object["snmp"]["enabled"] == 1) {
      $isEnabled = intval($object["snmp"]["enabled"]);
      $trapip = $object["snmp"]["trapip"];
      $port = $object["snmp"]["trapport"];
   }

   if (isset($server->snmp->enabled)) {
      if ($server->snmp->enabled != $isEnabled) {
         ParamSetInt($sock, "server.snmp.enabled", $isEnabled);
      }
   } else {
      ParamSetInt($sock, "server.snmp.enabled", $isEnabled);
   }
   if (isset($server->snmp->trapip)) {
      if ($server->snmp->trapip != $trapip) {
         ParamSetString($sock, "server.snmp.trapip", $trapip);
      }
   } else {
      ParamSetString($sock, "server.snmp.trapip", $trapip);
   }
   if (isset($server->snmp->trapport)) {
      if ($server->snmp->trapport != $port) {
         ParamSetInt($sock, "server.snmp.trapport", $port);
      }
   } else {
      ParamSetInt($sock, "server.snmp.trapport", $port);
   }
}

function changeUpLink($sock, $server, $object)
{
   if (!isset($object["upLink"]) || !isset($object["upLink"]["enabled"])) {
      return;
   }

   if ($object["upLink"]["enabled"] != true) {
      if (isset($server->uplink->ip)) {
         ParamUnset($sock, "server.uplink.ip");
      }
      if (isset($server->uplink->port) && $server->uplink->port != 0) {
         ParamSetInt($sock, "server.uplink.port", 0);
      }
      return;
   }

   if (isset($object["upLink"]["ip"])) {
      if ($object["upLink"]["ip"] == "" || $object["upLink"]["ip"] == "0.0.0.0") {
         if (isset($server->uplink->ip)) {
            ParamUnset($sock, "server.uplink.ip");
         }
      } elseif (isset($server->uplink->ip)) {
         if ($server->uplink->ip != $object["upLink"]["ip"]) {
            ParamSetString($sock, "server.uplink.ip", $object["upLink"]["ip"]);
         }
      } else {
         ParamSetString($sock, "server.uplink.ip", $object["upLink"]["ip"]);
      }
   }

   if (isset($object["upLink"]["port"])) {
      $upPort = $object["upLink"]["port"] === "" ? 0 : $object["upLink"]["port"];

      if (isset($server->uplink->port)) {
         if ($server->uplink->port != $upPort) {
            ParamSetInt($sock, "server.uplink.port", $upPort);
         }
      } else {
         ParamSetInt($sock, "server.uplink.port", $upPort);
      }
   }
}
